﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    class Program
    {
        static void Main(string[] args)
        {
            double a = 5.4;
            double b = 3.0;

            PerformOperations(a, b);
            PerformFunctions(a, b);
        }

        private static void PerformOperations(double a, double b)
        {
            Console.WriteLine("Operations");
            Operation operation = Add;
            Console.WriteLine($"{a} + {b} = {operation.Invoke(a, b)}");
            operation = Subtract;
            Console.WriteLine($"{a} - {b} = {operation(a, b)}");
            operation = Multiply;
            Console.WriteLine($"{a} * {b} = {operation(a, b)}");
            operation = Divide;
            Console.WriteLine($"{a} / {b} = {operation(a, b)}");

            // C# 2.0: A delegate can be initialized with inline code, called an "anonymous method"
            operation = delegate (double x, double y) { return Math.Pow(x, y); };

            // C# 3.0. A delegate can be initialized with a lambda expression - type is inferred by compiler
            operation = (x, y) => Math.Pow(x, y);

            //a method with the same signature can be easilly assigned
            operation = Math.Pow;
            Console.WriteLine($"{a} pow {b} = {operation(a, b)}");

            // method or delegate can be sent to method => even more separation from the caller and callee
            Console.WriteLine($"{a} pow {b} = {PerformOperation(a, b, Math.Pow)}");

            // lamda expression can be sent to a method
            Console.WriteLine($"{a} + {b} = {PerformOperation(a, b, (x, y) => x + y)}");
        }

        private static double PerformOperation(double a, double b, Operation operation) => operation(a, b);

        private static void PerformFunctions(double a, double b)
        {
            Console.WriteLine("Functions");
            Func<double, double, double> operation = Add;
            Console.WriteLine($"{a} + {b} = {operation.Invoke(a, b)}");
            operation = Subtract;
            Console.WriteLine($"{a} - {b} = {operation(a, b)}");
            operation = Multiply;
            Console.WriteLine($"{a} * {b} = {operation(a, b)}");
            operation = Divide;
            Console.WriteLine($"{a} / {b} = {operation(a, b)}");

            // C# 2.0: A delegate can be initialized with inline code, called an "anonymous method"
            operation = delegate (double x, double y) { return Math.Pow(x, y); };

            // C# 3.0. A delegate can be initialized with a lambda expression - type is inferred by compiler
            operation = (x, y) => Math.Pow(x, y);

            //a method with the same signature can be easilly assigned
            operation = Math.Pow;
            Console.WriteLine($"{a} pow {b} = {operation(a, b)}");

            // method or delegate can be sent to method => even more separation from the caller and callee
            Console.WriteLine($"{a} pow {b} = {PerformFunction(a, b, Math.Pow)}");

            // lamda expression can be sent to a method
            Console.WriteLine($"{a} + {b} = {PerformFunction(a, b, (x, y) => x + y)}");
        }

        private static double PerformFunction(double a, double b, Func<double, double, double> function) => function(a, b);

        private static double Add(double a, double b) => a + b;
        private static double Subtract(double a, double b) => a - b;
        private static double Multiply(double a, double b) => a * b;
        private static double Divide(double a, double b) => a == 0 || b == 0 ? 0 : a / b;
       
        private delegate double Operation(double a, double b);
    }
}
