﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadataka.Dal;
using Zadataka.Events;
using Zadataka.Exceptions;

namespace Zadataka.Models
{
     class PersonManager
    {
        public event OnLoadedEventHandler OnLoaded;
        public event OnExceptionEventHandeler OnException;

        private readonly IRepo repo;

        private IDictionary<string, Person> peopleDictionary;

        public PersonManager()=>repo=RepoFactory.GetRepo();

        public IDictionary<string, Person> PeopleDictionry
        {
            get
            {
                if (peopleDictionary == null)
                {
                    Load();
                }
                return new Dictionary<string, Person>(peopleDictionary);
            }
        }

        private void Load()
        {
            try 
            {
                IList<Person> people=repo.LoadPeople();
                FillDictionary(people);
            }
            catch (Exception e) 
            {
                OnException?.Invoke(this, new OnExceptionEventArgs { Exception = e });
            }
        }

        private void FillDictionary(IList<Person> people)
        {
            peopleDictionary = new Dictionary<string, Person>();
            people.ToList().ForEach(p =>
            {
                try
                {
                    if (p.HasValidOib())
                    {
                        peopleDictionary.Add(p.Oib, p);
                        IList<string> missingData = FillMissingData(p);

                        OnLoaded?.Invoke(this, new OnLoadedEventArgs
                        {
                            LoadedPerson = p,
                            MissingData = missingData
                        });
                    }
                    else
                    {
                        //throw new Exceptions.InvalidOibException();
                        throw new InvalidOibException($"{p.Oib} - OIB nije ispravan!");
                    }
                }
                catch (Exception e)
                {
                    OnException?.Invoke(this, new OnExceptionEventArgs { Exception = e });
                }
            });
        }

        private IList<string> FillMissingData(Person p)
        {
            IList<string> missingData=new List<string>();
            if (string.IsNullOrEmpty(p.Ime))
            {
                missingData.Add(nameof(Person.Ime));
            }
            if (string.IsNullOrEmpty(p.Prezime))
            {
                missingData.Add(nameof(Person.Prezime));
            }
            if (string.IsNullOrEmpty(p.Telefon))
            { 
                missingData.Add(nameof (Person.Telefon));
            }
            if (string.IsNullOrEmpty(p.Email))
            {
                missingData.Add(nameof(Person.Email));
            }
            return missingData;
        }

        public void Save(IList<Person> p)
        {
            try
            {
                repo.SavePeople(p);
            }
            catch (Exception e)
            { 
                OnException?.Invoke(this, new OnExceptionEventArgs { Exception=e });
            }
        }
    }
}
