﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    class Program
    {
        static void Main(string[] args)
        {
            // program to interfaces not implementations! - left side should be parent class, abstract class or interface; right side should be concrete class
            ISwitchable lightBulb = new LightBulb
            {
                FilamentLength = 12,
                Power = 10
            };
            Console.WriteLine(lightBulb);
            lightBulb.SwitchOn();
            lightBulb.SwitchOff();
            Console.WriteLine("----------------------------------------------------");
            ISwitchable stove = new Stove
            {
                Producer = "Gorenje",
                Type = Stove.StoveType.Combined
            };
            Console.WriteLine(stove);
            stove.SwitchOn();
            stove.SwitchOff();
            Console.WriteLine("----------------------------------------------------");

            EnumDemo();

            IRemoteControllable universalRemoteController = new UniversalRemoteController();
            universalRemoteController.SwitchOn();
            universalRemoteController.VolumeUp();
            universalRemoteController.VolumeDown();
            universalRemoteController.SwitchOff();
            Console.WriteLine("----------------------------------------------------");

            IList<ISwitchable> list = new List<ISwitchable>
            {
                lightBulb,
                stove,
                // IRemoteControllable is also ISwitchable, so it can be put in the list of ISwitchables
                universalRemoteController
            };

            //foreach (var sw in list)
            //{
            //    sw.SwitchOn();
            //    // we are working with complete abstractions - nothing is concrete here:
            //    if (sw is IRemoteControllable irc)
            //    {
            //        irc.VolumeUp();
            //        irc.VolumeDown();
            //    }
            //    sw.SwitchOff();
            //}

            // lambda:
            list.ToList().ForEach(sw =>
                {
                    sw.SwitchOn();
                    // we are working with complete abstractions - nothing is concrete here:
                    if (sw is IRemoteControllable irc)
                    {
                        irc.VolumeUp();
                        irc.VolumeDown();
                    }
                    sw.SwitchOff();
                });
        }

        private static void EnumDemo()
        {
            // listing enum values - we can use var (instead of Array) - the compiler recognizes
            var values = Enum.GetValues(typeof(Stove.StoveType));
            foreach (var value in values)
            {
                // each enum has a integer representation and ToString() overriden
                Console.WriteLine($"{(int)value} - {value}");
            }

            // parsing enum from string
            if (Enum.TryParse("Gas", out Stove.StoveType type))
            {
                Console.WriteLine(type);
            }

            // casting int into enum 
            int val = 3;
            if (Enum.IsDefined(typeof(Stove.StoveType), val))
            {
                // as operator does not work so we use explicit cast
                type = (Stove.StoveType)val;
                Console.WriteLine(type);
            }

            Console.WriteLine("----------------------------------------------------");
        }
    }
}
