﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    class Point
    {
        // breaking encapsulation problem
        //public int x;
        private int x;
        private int y;

        // we must open the access to variables - Properties
        public int X
        {
            get
            {
                // this is reduntant!
                return this.x;
            }
            set
            {
                // there is implicit value parameter that must be checked for range - example[0, 100]
                if (value < 0 || value > 100)
                {
                    throw new Exception("Coordinate must be in range [0-100]");
                }
                // reduntant this
                this.x = value;
            }
        }

        // prop + tab + tab
        public int Y
        {
            get
            {
                return y;
            }
            set
            {
                if (value < 0 || value > 100)
                {
                    throw new Exception("Coordinate must be in range [0-100]");
                }
                y = value;
                // be aware of this - it produces StackOverflowException, because of recursion!
                //Y = value;
            }

        }

        public Point(int x, int y)
        {
            // we must protect the x, y coordinates
            //if (x < 0 || x > 100 || y < 0 || y > 100)
            //{
            //    throw new Exception("Coordinates must be in range [0-100]");
            //}
            //this.x = x;
            //this.y = y;

            // but this is all redundant! it is better to call the Properties
            X = x;
            Y = y;
        }

        // this method is not good -> it takes for granted that this is a console app! 
        //public void PrintDetails()
        //{
        //    Console.WriteLine($"({X}, {Y})");
        //}

        // this is the proper way
        public override string ToString()
        {
            return $"P({X}, {Y})";
        }

    }
}
