﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Vjezbe11.PodatkovniSloj;

namespace Klijent
{
    internal class Program
    {
        static void Main(string[] args)
        {
            IRepository repo = RepositoryFactory.GetRepository();

            try
            {
                AddItems(repo);
                GetItems(repo);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void AddItems(IRepository repo)
        {
            repo.AddItem(new Item
            {
                Date = DateTime.Now,
                Description = "First to do item",
                Id = 1,
                User = new User
                {
                    Id = 1,
                    FirstName = "Pero",
                    LastName = "Peric"
                }
            });
            repo.AddItem(new Item
            {
                Date = DateTime.Now.AddDays(1),
                Description = "Second to do item",
                Id = 2,
                User = new User
                {
                    Id = 2,
                    FirstName = "Ana",
                    LastName = "Anic"
                }
            });
        }

        private static void GetItems(IRepository repo)
        {
            ISet<Item> items = repo.GetItems();
            foreach (Item item in items)
            {
                // [1]: First to do item, {Date}, ([1] Pero Peric)
                // [2]: Second to do item, {Date}, ([2] Ana Anic)
                Console.WriteLine(item);
            }
        }
    }
}
