﻿using CleanCode.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    class Subject : ISignable
    {
        public string Code { get; set; }
        public string Title { get; set; }

        private int points;
        public int Points
        {
            get => points;
            set
            {
                if (value < 20 || value > 30)
                {
                    throw new Exception("Subject ects must be 20-30");
                }
                points = value;
            }
        }
        // no one should set approved but Dean - it is not in the requirement
        public bool Approved { get; private set; }
        public override string ToString() => $"Code: {Code}, Title: {Title}, Points: {Points.IntInFormat("ests")}, Approved: {(Approved ? "yes" : "no")}";
        public void Sign() => Approved = true;
    }
}
