﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    internal class Student : Osoba, IComparable<Student>
    {
        private static int idGenerator;
        private readonly int id;

        public enum StudentTip
        { 
            Izvanredni =1, 
            Redovni
        }
        public StudentTip Tip { get; set; }
        public Student(string ime, string prezime, StudentTip tip) : base(ime, prezime)
        {
            Tip = tip;
            id = ++idGenerator;
        }

        public override string ToString()=>$"ID: {id}, {base.ToString()}, Tip: {Tip}";

        public override bool Equals(object obj) => obj is Student other ? id == other.id : false;
        public override int GetHashCode() => id.GetHashCode();

        public int CompareTo(Student other)=>-id.CompareTo(other.id) ;
    }
}
