﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    internal class Program
    {
        static void Main(string[] args)
        {
            PeopleManager manager = new PeopleManager();
            manager.OnPersonLoaded += Manager_OnPersonLoaded;

            try
            {
                // AddPerson i LoadPeople rade s FileRepository
                // koji pise i cita iz filea
                // i moze throwati exception
                manager.AddPerson(new Person
                {
                    OIB = "1234242423",
                    FirstName = "Ana",
                    LastName = "Anic",
                    Phone = "098098098",
                    Email = "ana@mail.com"
                });

                manager.LoadPeople();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void Manager_OnPersonLoaded(
            object sender, PersonEventArgs args)
        {
            PrintMessage(args.Person.ToString(), ConsoleColor.Green);
        }

        private static void PrintMessage(string message, ConsoleColor color)
        {
            Console.ForegroundColor = color;
            Console.WriteLine(message);
            Console.ResetColor();
        }
    }
}
