﻿using CleanCode.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    class Predmet : ISignable
    {
        public string Code {  get; set; }
        public string Naziv {  get; set; }
        private int ects;
        public int ECTS
        {
            get => ects;
            set 
            {
                if (value < 20 || value > 30)
                {
                    throw new Exception("ECTS bodovi moraju biti izmedu 20 - 30 !");
                }
                ects = value;
            }
        }

        //nijedan predmet nije odobren ako ga ne odobri Dekan - ne piše u uputama
        public bool Odobren { get; private set; }

        public override string ToString()=>$"Sifra: {Code}, Naziv: {Naziv}, ECTS: {ECTS.IntInFormat("ecst")},Odrobren: {(Odobren ? "DA":"NE")}";

        public void Sign()=>Odobren = true;
    }
}
