﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Program
    {
        private delegate double Operation(double a, double b);

        private static double Add(double a, double b)=>a+b;
        private static double Subtract(double a, double b)=>a-b;
        private static double Multiply(double a, double b) => a * b;
        private static double Divide(double a, double b) =>a==0 || b==0?0:a/b;
        static void Main(string[] args)
        {
            double a = 5.2;
            double b = 3.0;

            PerformOprations(a, b);
            PerformFunctions(a, b);
        }

        private static void PerformFunctions(double a, double b)
        {
            Console.WriteLine("Funkcije");
            Func<double, double, double> operation = Add;
            Console.WriteLine($"{a}+{b}={operation.Invoke(a, b)}");
            operation = Subtract;
            Console.WriteLine($"{a}-{b}={operation(a, b)}");
            operation = Multiply;
            Console.WriteLine($"{a}*{b}={operation(a, b)}");
            operation = Divide;
            Console.WriteLine($"{a}/{b}={operation(a, b)}");

            //C# 2.0 delegat moze biti inicijaliziran upotrebom inline code, "anonimna metoda"
            operation = delegate (double x, double y) { return Math.Pow(x, y); };

            //C# 3.0 delegat moze inicijalizirati upotrebom lambde
            operation = (x, y) => Math.Pow(x, y);

            //metodu mogu sa istim potpisom jednostavno dodijeliti
            operation = Math.Pow;
            Console.WriteLine($"{a} pow {b}= {operation(a, b)}");

            //metoda ili delgat moze biti poslana od same metode => omogućuje jos veću separaciju pozivatelja i pozvanoga
            Console.WriteLine($"{a} pow {b}= {PerformFunction(a, b, Math.Pow)}");

            //lambda se može poslati kao metoda
            Console.WriteLine($"{a}+{b}={PerformFunction(a, b, (x, y) => x + y)}");
        }

        private static object PerformFunction(double a, double b, Func<double, double, double> function)
            =>function(a, b);
        

        private static void PerformOprations(double a, double b)
        {
            Console.WriteLine("Operacije: ");
            Operation operation = Add;
            Console.WriteLine($"{a}+{b}={operation.Invoke(a,b)}");
            operation=Subtract;
            Console.WriteLine($"{a}-{b}={operation(a, b)}");
            operation=Multiply;
            Console.WriteLine($"{a}*{b}={operation(a,b)}");
            operation=Divide;
            Console.WriteLine($"{a}/{b}={operation(a, b)}");

            //C# 2.0 delegat moze biti inicijaliziran upotrebom inline code, "anonimna metoda"
            operation=delegate(double x, double y) { return Math.Pow(x,y); };

            //C# 3.0 delegat moze inicijalizirati upotrebom lambde
            operation=(x,y)=> Math.Pow(x,y);

            //metodu mogu sa istim potpisom jednostavno dodijeliti
            operation = Math.Pow;
            Console.WriteLine($"{a} pow {b}= {operation(a,b)}");

            //metoda ili delgat moze biti poslana od same metode => omogućuje jos veću separaciju pozivatelja i pozvanoga
            Console.WriteLine($"{a} pow {b}= {PerformOperations(a,b,Math.Pow)}");

            //lambda se može poslati kao metoda
            Console.WriteLine($"{a}+{b}={PerformOperations(a, b, (x, y) => x + y)}");
        }

        private static object PerformOperations(double a, double b, Operation operation)=>operation(a,b);
    }
}
