﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        private delegate void Broadcast(string message);
        static void Main(string[] args)
        {
            string message = "Sretna Nova 2025!";
            PerformMulticast(message);
            Console.WriteLine();
            PerformMultcastActions(message);
        }

        private static void PerformMultcastActions(string message)
        {
            Console.WriteLine("Multicast Actions");
            Action<string> emailBroadcast = SendEmail;
            Action<string> messageBroadcast = SendMessage;

            Action<string> multicast = emailBroadcast + messageBroadcast;
            multicast += Ping;

            //slanje lambda izraza
            multicast += (text) => Console.WriteLine($"sending text: {text}");

            //imamo opasnu situaciju kod operatora "=", jer on overwrites ave dodljene delgate!
            //multicast= (text) => Console.WriteLine($"sending text: {text}");

            multicast -= emailBroadcast;
            multicast -= messageBroadcast;
            multicast -= Ping;


            //također može biti opasno ukoliko nemam niti jendog delegata
            //multicast(message);

            multicast?.Invoke(message);
        }

        private static void PerformMulticast(string message)
        {
            Console.WriteLine("Multicast");
            Broadcast emailBroadcast = SendEmail;
            Broadcast messageBroadcast = SendMessage;

            Broadcast multicast=emailBroadcast+messageBroadcast;
            multicast += Ping;

            //slanje lambda izraza
            multicast += (text) => Console.WriteLine($"sending text: {text}");

            //imamo opasnu situaciju kod operatora "=", jer on overwrites ave dodljene delgate!
            //multicast= (text) => Console.WriteLine($"sending text: {text}");

            multicast -= emailBroadcast;
            multicast-= messageBroadcast;
            multicast -= Ping;


            //također može biti opasno ukoliko nemam niti jendog delegata
            //multicast(message);

            multicast?.Invoke(message);
        }

        private static void Ping(string message) => Console.WriteLine($"Pinging: {message}");

        private static void SendMessage(string message)=>Console.WriteLine($"Sending message: {message}");

        private static void SendEmail(string message)=>Console.WriteLine($"Sending email: {message}");
    }
}
