﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            PredicatesDemo();
            ConvertersDemo();
            ComparisonDemo();
        }

        private class Product
        { 
            public int Id { get; set; }
            public string Title { get; set; }
            public override string ToString()=>$"{Id} - {Title}";
        }

        private static void ComparisonDemo()
        {
            Console.WriteLine("---------COMPARISON---------");
            List<Product> products = new List<Product>
            { 
                new Product {Id=1, Title="Role"},
                new Product{Id=2, Title="Skateboard"},
                new Product{Id=3, Title="Romobil"},
            };
            Console.WriteLine("ID asc:");
            Comparison<Product> idASC=(a,b)=>a.Id.CompareTo(b.Id);
            products.Sort(idASC);
            products.ForEach(Console.WriteLine);

            Console.WriteLine("Title DESC:");
            products.Sort((a,b)=>-a.Title.CompareTo(b.Title));
            products.ForEach(Console.WriteLine);
        }

        private static void ConvertersDemo()
        {
            Console.WriteLine("------CONVERTER-------");
            string broj = "2";
            Converter<string, int> stringToInt = int.Parse;

            //kao funkcija
            //Func<string, int>stringToInt = int.Parse;
            Console.WriteLine(stringToInt(broj));

            Converter<double, double> cesiusToKelvin = c => c + 273.15;
            double temp = -2;
            Console.WriteLine($"{temp} oC= {cesiusToKelvin(temp)} K");
        }

        private static void PredicatesDemo()
        {
            Console.WriteLine("-------PREDICATE---------");
            Console.WriteLine("Pozitivni brojevi:");
            Predicate<int> positiveNumber = PositiveNumber;

            //Predicate<int> možemo izraziti pomoću funkcije Func<int, bool>:
            //Func<int, bool> positiveNumber=PositiveNumber;

            //u principu nam metoda niti ne treba, kompletnu funkcionalnost možemo dobiti premo lambde
            positiveNumber = n => n > 0;

            List<int> lista= new List<int>();
            Random rnd = new Random();
            for (int i = 0; i < 10; i++)
            {
                int broj= rnd.Next(-10,10);
                Console.WriteLine(positiveNumber(broj) ? $"{broj} je pozitivan" : $"{broj} je negativan");
                lista.Add(broj);
            }

            Console.WriteLine($"Pozitivni: {lista.Find(positiveNumber)}");
            Console.WriteLine($"Event: {lista.Find(n => n % 2 != 0)}");

            Console.WriteLine("STRINGOVI:");
            Predicate<string> isNeitherNullOrEmpty = s => s != null && s.Trim().Length != 0;
            string test = "Ana";
            test = " ";
            test = "";
            test =null;
            Console.WriteLine(isNeitherNullOrEmpty(test)?"Imamo string":"Null ili prazan string");

        }

        private static bool PositiveNumber(int n) => n > 0;
      
    }
}
