﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Color
    {
        // u slucaju validacije, prvo definiramo privatnu varijablu
        private int red;
        public int Red
        {
            get
            {
                return red;
            }
            set
            {
                // u slucaju iznimke (ako broj nije u rasponu), throwaj exception
                if (value < 0 || value > 255)
                {
                    throw new Exception("Red must be between 0 and 255!");
                }
                red = value;
            }
        }

        public int Green { get; set; }
        public int Blue { get; set; }

        public Color() { }

        public Color(int red, int green, int blue)
        {
            Red = red;
            Green = green;
            Blue = blue;
        }

        public override string ToString()
        {
            return $"(R: {Red}, G: {Green}, B: {Blue})";
        }
    }
}
