﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak1
{
    internal class Program
    {
        static void Main(string[] args)
        {
            ISwitchable zarulja = new LightBulb
            {
                DuljinaNiti=10,
                Power=30
            };
            Console.WriteLine(zarulja);
            zarulja.SwitchOn();
            zarulja.SwitchOff();
            Console.WriteLine();

            ISwitchable pec = new Stove
            { 
                Producer="Gorenje",
                Type=Stove.StoveType.Combined
            };
            Console.WriteLine(pec);
            pec.SwitchOn();
            pec.SwitchOff();
            Console.WriteLine() ;

            IRemoteControle daljinski = new UniverzaniDaljinski();
            daljinski.SwitchOn();
            daljinski.SwitchOff();
            daljinski.VolumeDown(); 
            daljinski.VolumeUp();
            Console.WriteLine();

            List<ISwitchable> listaInterfaca = new List<ISwitchable>();
            listaInterfaca.Add(zarulja);
            listaInterfaca.Add(pec);
            listaInterfaca.Add(daljinski);

            foreach (ISwitchable item in listaInterfaca)
            { 
                item.SwitchOn();
                item.SwitchOff();
                if (item is IRemoteControle irc)
                {
                    irc.VolumeUp();
                    irc.VolumeDown();
                }
            }
        }
    }
}
