﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak2
{
    internal class Book:IComparable<Book>
    {
        public int Id { get;  private set; }

        private string isbn;
        public string ISBN
        {
            get { return isbn; }
            set 
            {
                if (!IsValidIsbn(value))
                    throw new Exception("ISBN mora imati 13 brojeva!");
                isbn = value;
            }
        }

        private bool IsValidIsbn(string value)
        {
            if(value.Length!=13)
                return false;
            foreach (char s in value)
            { 
                if(!char.IsDigit(s))
                    return false;
            }
            return true;

            //return value.All(s=>char.IsDigit(s));
        }

        public string Title {  get; set; }
        public string Author { get; set; }

        private static int idGenerator = 1;
        public Book(string iSBN, string title, string author)
        { 
            Id = idGenerator++;
            ISBN = iSBN;
            Title = title;
            Author = author;   
        }

        public override string ToString()
        {
            return $"ID: {Id}, ISBN: {ISBN}, Naslov: {Title}, Autor: {Author}";
        }

        public int CompareTo(Book other)
        {
            ////ako je prvi veci od drugog
            //if (long.Parse(this.ISBN) > long.Parse(other.ISBN))
            //{
            //    return 1;
            //}
            ////ako je prvi manji od drugog
            //else if (long.Parse(this.ISBN) < long.Parse(other.ISBN))
            //{
            //    return -1;
            //}
            ////ako su isti
            //else
            //{
            //    return 0;            
            //}

            //ASC- rastući
            //return ISBN.CompareTo(other.ISBN);

            //DESC - padajući (ASC mnozenje s -1)
            return -ISBN.CompareTo(other.ISBN);
        }
    }
}
