﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadataka.Models;

namespace Zadataka
{
    internal class Program
    {
        static void Main(string[] args)
        {
            try 
            {
                PersonManager personManager = new PersonManager();
                personManager.OnException += PersonManager_OnException;
                personManager.OnLoaded += PersonManager_OnLoaded;

                IDictionary<string, Person>people= personManager.PeopleDictionry;
                ShowMessage("\nUcitani podaci\n", ConsoleColor.White);
            }
            catch(Exception e) { ShowMessage(e.Message, ConsoleColor.Red); }
        }

        private static void ShowMessage(string message, ConsoleColor color)
        {
            Console.ForegroundColor = color;
            Console.WriteLine(message);
            Console.ResetColor();   
        }

        private static void PersonManager_OnLoaded(object sender, Events.OnLoadedEventArgs e)
        {
            if (e.MissingData.Count == 0)
                ShowMessage(e.LoadedPerson.ToString(), ConsoleColor.Green);
            else
            { 
                string report=string.Join(", ", e.MissingData);
                ShowMessage(report, ConsoleColor.Blue);
            }
        }

        private static void PersonManager_OnException(object sender, Events.OnExceptionEventArgs e)
        => ShowMessage(e.Exception.Message, ConsoleColor.Red);
    }
}
