﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Program
    {
        static void Main(string[] args)
        {
            double a = 5.5;
            double b = 7.7;

            // delegatu "MathOperation" pridodijelite referencu na metodu
            MathOperation mathOperation = Add;

            double result = mathOperation.Invoke(a, b);
            Console.WriteLine($"{a} + {b} = {result}");
            result = mathOperation(a, b);
            Console.WriteLine($"{a} + {b} = {result}");

            mathOperation = Subtract;
            Console.WriteLine($"{a} - {b} = {mathOperation(a, b)}");

            mathOperation = Math.Pow;
            Console.WriteLine($"{a} ^ {b} = {mathOperation(a, b)}");

            result = PerformMathOperation(a, b, Multiply);
            Console.WriteLine($"{a} * {b} = {result}");

            // predajemo anonimnu metodu preko lambda funkcije
            result = PerformMathOperation(a, b, (x, y) =>  x / y);
            Console.WriteLine($"{a} / {b} = {result}");

            // Koristenje ugradjenog Func delegata
            Func<double, double, double> funcMathOperation = Add;
            Console.WriteLine($"{a} + {b} = {funcMathOperation(a, b)}");

            funcMathOperation = Math.Pow;
            Console.WriteLine($"{a} ^ {b} = {funcMathOperation(a, b)}");
        }

        private static double Multiply(double x, double y)
        {
            return x * y;
        }

        private static double PerformMathOperation(double x, double y,
            MathOperation mathOperation)
        {
            return mathOperation(x, y);
        }

        private static double Subtract(double x, double y)
        {
            return x - y;
        }

        private static double Add(double x, double y) { return x + y; }

        private delegate double MathOperation(double x, double y);
    }
}
