﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    public class Country : IComparable<Country>
    {
        public int Id { get; set; }
        public string Name { get; set; }

        private List<City> Cities { get; set; } = new List<City>();

        public int CompareTo(Country other)
        {
            return -this.Name.CompareTo(other.Name);
        }

        public override string ToString()
        {
            return $"[{Id}] {Name}";
        }

        public int CitiesCount() { return Cities.Count; }

        // Indexer
        // country[0] = new City()
        public City this[int index]
        {
            get => Cities[index];
            set => Cities.Insert(index, value);
        }

        // country["Split"]
        public City this[string name]
        {
            get => Cities.FirstOrDefault(city => city.Name == name);
        }
    }
}
