﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;

namespace TrelloRepo.Repository
{
    internal class FileRepository : IRepository
    {
        // @ - verbatim - it tells the string constructor to ignore escape characters and line breaks
        private const string USERS_PATH = @"C:\Users\daniel.bele\Desktop\data\users.txt";
        private const string ITEMS_PATH = @"C:\Users\daniel.bele\Desktop\data\items.txt";

        // we have a single entry point (constructor) - here we ensure that we have the files!
        public FileRepository() => CreateFilesIfNonExistent();

        private void CreateFilesIfNonExistent()
        {
            if (!File.Exists(USERS_PATH))
            {
                // we must immediately close the file!!!
                File.Create(USERS_PATH).Close();
            }
            if (!File.Exists(ITEMS_PATH))
            {
                File.Create(ITEMS_PATH).Close();
            }
        }

        public void AddItem(Item item)
        {
            AddUser(item.User);
            ISet<Item> items = GetItems();
            items.Add(item);
            File.WriteAllLines(ITEMS_PATH, items.Select(i => i.FormatForFileLine()));
        }

        private void AddUser(User user)
        {
            ISet<User> users = GetUsers();
            users.Add(user);
            //string[] lines = new string[users.Count];
            //int pos = 0;
            //foreach (var u in users)
            //{
            //    lines[pos++] = u.FormatForFileLine();
            //}
            //File.WriteAllLines(USERS_PATH, lines);
            File.WriteAllLines(USERS_PATH, users.Select(u => u.FormatForFileLine()));
        }

        public ISet<Item> GetItems()
        {
            ISet<Item> items = new HashSet<Item>();
            string[] lines = File.ReadAllLines(ITEMS_PATH);
            lines.ToList().ForEach(line => items.Add(Item.ParseFromFileLine(line)));
            return items;
        }

        public User GetUser(int id) => GetUsers().FirstOrDefault(u => u.Id == id);

        public ISet<User> GetUsers()
        {
            ISet<User> users = new HashSet<User>();
            string[] lines = File.ReadAllLines(USERS_PATH);
            //foreach (var line in lines)
            //{
            //    users.Add(User.ParseFromFileLine(line));
            //}
            lines.ToList().ForEach(line => users.Add(User.ParseFromFileLine(line)));
            return users;
        }
    }
}
