﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    class Program
    {
        static void Main(string[] args)
        {
            Frog f1 = new Frog
            {
                NumberOfLegs = 2,
                Color = "red",
            };
            Console.WriteLine(f1);
            Frog f2 = new Frog
            {
                NumberOfLegs = 2,
                Color = "red"
            };
            Console.WriteLine(f2);
            
            Console.WriteLine(f1 == f2);
            Console.WriteLine(f1.Equals(f2));

            // HashSet does not take duplicates -> so it calls GetHashCode() on an element before inserting
            // it means we have to override also the GetHashCode(), any time we implement Equals(obj) !!!
            // left side is not specific -> can be any ISet (they all behave the same), right side is specific (HashSet - it uses GetHashCode())!
            ISet<Frog> frogs = new HashSet<Frog>
            {
                f1,
                f2
            };
            // impicit type var - it is still "strongly typed", but the compiler determines the type
            foreach (var frog in frogs)
            {
                Console.WriteLine(frog);
            }
        }
    }
}
