﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;

namespace TrelloRepo
{
    class MemoryRepository : IRepository
    {
        //lovimo entitete u memoriji u ISet<> - tamo nema duplikata
        private readonly ISet<User> users=new HashSet<User>();
        private readonly ISet<Item> items=new HashSet<Item>();

        public void AddItem(Item item)
        {
            //pošto imamo metodu za dodavanje Usersa, nemoramo ju ponovno raditi
            users.Add(item.User);
            items.Add(item);
        }


        //moramo vratiti kopiju, nikako original - umjesto toga možemo pozvati iz klijenta i očisti 
        //public ISet<Item> GetItems()=>items;
        public ISet<Item> GetItems()=>new HashSet<Item>(items);

        public User GetUser(int id)=>users.FirstOrDefault(x=>x.Id==id);
            //FirstOrDefault() -> vraća prvi čalna po nekom uvjetu ili vraća default (null)
        //{
        //    foreach (var u in users)
        //    {
        //        if (u.Id == id)
        //            return u;
        //    }
        //    return null;
        //}

        public ISet<User> GetUsers()=>new HashSet<User>(users);
    }
}
