﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Car car = new Car(123, "Mercedes", 8.9);
            car.Drive();
            car.Stop();
            Console.WriteLine(car);
            Console.WriteLine();

            SportCar sportCar=new SportCar(321, "Ferrari",3.5,true);
            sportCar.Drive();
            sportCar.Stop();
            sportCar.Drift();
            Console.WriteLine(sportCar);
            Console.WriteLine();

            //implicitno upcastanje - svaki sport car je car
            Car car2=sportCar;
            car2.Drive();
            car2.Stop();

            //exsplicitno downcastanje - nije savi auto i sportski auto
            //SportCar sportCar2=(SportCar)car; //exsplicitno castanje je jako opasno!
            if (car2 is SportCar sportCar2)
            {
                sportCar2.Drift();
            }
            Console.WriteLine();

            //prednosti polymorphizma
            //1 jedinstvena lista za sve car
            //lijeva strana nije specificirana - može biti bilo koja IList (svaka se ponaša isto)
            //s desne strane mora biti specifična List<Car>
            IList<Car> cars = new List<Car> 
            { 
                car,
                sportCar,
                new Truck(345,"Scania",20.8,100)
            };

            foreach (var c in cars)
            {
                c.Drive();
                c.Stop();
                if (c is SportCar sc2)
                { 
                    sc2.Drift();
                }
                //2 jedinstvenu metodu za sve car
                PrintDetails(c);
            }
        }

        private static void PrintDetails(Car c)=>Console.WriteLine(c);
    }
}
