﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string message = "Danas je srijeda";

            Broadcast emailBroadcast = SendMail;
            emailBroadcast(message);
            Console.WriteLine();

            Broadcast smsBroadcast = SendSms;

            Broadcast multicast = emailBroadcast + smsBroadcast;
            multicast(message);
            Console.WriteLine();

            multicast += SendWapp;
            // pretplata koristeci lambda izraz
            multicast += (msg) => Console.WriteLine($"Sending Viber: {msg}");

            multicast -= smsBroadcast;

            //multicast(message);
            //multicast = null;
            // preporuka poziva kako ne bi dobili NullReferenceException
            multicast?.Invoke(message);
            Console.WriteLine();
            
            // =====================================
            // Koristenje ugradjenog Action delegata
            Action<string> actionMulticast = SendMail;
            actionMulticast += SendWapp;
            actionMulticast += Console.WriteLine;

            actionMulticast?.Invoke(message);
            Console.WriteLine();

            // =========================
            // Dodatak built-in delegata
            List<string> list = new List<string> { "jedan", "dva", "tri" };
            list.ForEach(str => Console.WriteLine(str));
            Console.WriteLine();
            list.ForEach(Console.WriteLine);
            Console.WriteLine();

            list.Where((str) => str.Length == 3)
                .ToList()
                .ForEach(Console.WriteLine);
        }

        private static void SendWapp(string message)
        {
            Console.WriteLine($"Sending WAPP: {message}");
        }

        private static void SendSms(string message)
        {
            Console.WriteLine($"Sending SMS: {message}");
        }

        private static void SendMail(string message)
        {
            Console.WriteLine($"Sending mail: {message}");
        }

        private delegate void Broadcast(string message);
    }
}
