﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class ComplexNumber/* : Object*/
    {
        public int Re { get; set; }
        public int Im { get; set; }

        public ComplexNumber() { }
        public ComplexNumber(int re, int im)
        {
            Re = re;
            Im = im;
        }

        public override string ToString()
        {
            return $"{Re} + {Im}i";
        }

        public override bool Equals(object obj)
        {
            //if (obj is ComplexNumber number)
            //{
            //    return Re == number.Re && Im == number.Im;
            //}
            //return false;

            // ako obj je ComplexNumber, odmah ga castaj u number
            return obj is ComplexNumber number &&
                   Re == number.Re &&
                   Im == number.Im;
        }

        public override int GetHashCode()
        {
            int hashCode = 29377563;
            hashCode = hashCode * -1521134295 + Re.GetHashCode();
            hashCode = hashCode * -1521134295 + Im.GetHashCode();
            return hashCode;
        }

        //public override bool Equals(object obj)
        //{
        //    // ako obj nije ComplexNumber
        //    if (!(obj is ComplexNumber))
        //    {
        //        return false;
        //    }

        //    ComplexNumber other = obj as ComplexNumber;

        //    return (this.Re == other.Re && 
        //        this.Im == other.Im);
        //}

        //public override int GetHashCode()
        //{
        //    return Re * 31 / Im;
        //}

        // overload operatora ==
        public static bool operator ==(ComplexNumber a, ComplexNumber b)
        {
            return a.Equals(b);
        }

        // overload operatora !=
        public static bool operator !=(ComplexNumber a, ComplexNumber b)
        {
            return !(a == b);
        }
    }
}
