﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;
using System.IO;

namespace TrelloRepo
{
    class FileRepository : IRepository
    {
        private const string USER_PATH = @"D:\Silvije\OOP\users.txt";
        private const string ITEM_PATH = @"D:\Silvije\OOP\items.txt";

        //ulazna točka (single entry point - constructor
        public FileRepository() => CreateFilesIfNonExistent();

        private void CreateFilesIfNonExistent()
        {
            if (!File.Exists(USER_PATH))
            {
                File.Create(USER_PATH).Close();
            }
            if (!File.Exists(ITEM_PATH))
            {
                File.Create(ITEM_PATH).Close();
            }
        }

        public void AddItem(Item item)
        {
            AddUser(item.User);
            ISet<Item> items = GetItems();
            items.Add(item);
            File.WriteAllLines(ITEM_PATH, items.Select(i => i.FormatForFileLine()));
        }

        private void AddUser(User user)
        {
            ISet<User> users = GetUsers();
            users.Add(user);

            //string[] lines= new string[users.Count];
            //int pos = 0;
            //foreach (var u in users)
            //{
            //    lines[pos++] = u.FormatForFileLine();
            //}
            //File.WriteAllLines(USER_PATH, lines);

            //ILI

            File.WriteAllLines(USER_PATH, users.Select(i => i.FormatForFileLine()));
        }

        public ISet<Item> GetItems()
        {
            ISet<Item> items= new HashSet<Item>();
            string[] lines= File.ReadAllLines(ITEM_PATH);
            //foreach (var line in lines)
            //{ 
            //    items.Add(Item.ParseFromFileLine(line));
            //}
            lines.ToList().ForEach(line => items.Add(Item.ParseFromFileLine(line)));
            return items;
        }

        public User GetUser(int id)=>GetUsers().FirstOrDefault(i => i.Id == id);

        public ISet<User> GetUsers()
        {
            ISet<User> users= new HashSet<User>();
            string[] lines = File.ReadAllLines(USER_PATH);
            lines.ToList().ForEach(line=>users.Add(User.ParseFromFileLine(line)));
            return users;
        }
    }
}
