﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    public class PizzaFactory
    {
        private const string CONFIG_PATH = "PizzaConfig.txt";

        public static Pizza GetPizza(string name)
        {
            Pizza pizza;

            switch (name)
            {
                //case "Capricciosa":
                case nameof(Capricciosa):
                    pizza = new Capricciosa();
                    break;
                case nameof(Margherita):
                    pizza = new Margherita();
                    break;
                default:
                    throw new Exception("There is no such pizza!");
            }

            FinishPizza(pizza);

            return pizza;
        }

        public static Pizza GetPizza(PizzaType type)
        {
            Pizza pizza = null;

            switch (type)
            {
                case PizzaType.Capricciosa:
                    pizza = new Capricciosa();
                    break;
                case PizzaType.Margherita:
                    pizza = new Margherita();
                    break;
                    //default:
                    //    throw new Exception("There is no such pizza!");
            }

            FinishPizza(pizza);

            return pizza;
        }

        // using reflection
        public static Pizza GetPizzaByFullClassName(string className)
        {
            Type type = Type.GetType(className);

            // koristeci reflection kreiramo novi objekt preko Typea
            Pizza pizza = Activator.CreateInstance(type) as Pizza;

            FinishPizza(pizza);
            return pizza;
        }

        public static Pizza GetPizzaByConfig()
        {
            string fullClassName = File.ReadAllText(CONFIG_PATH);
            return GetPizzaByFullClassName(fullClassName);
        }

        private static void FinishPizza(Pizza pizza)
        {
            pizza.Prepare();
            pizza.Bake();
            pizza.Serve();
            pizza.Charge();
        }
    }
}
