﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task03
{
    internal class Program
    {
		static void Main(string[] args)
		{
			//IDictionary<int, string> numbers = new Dictionary<int, string>(); // at the end, show why we should program to interfaces, not implementations
			IDictionary<int, string> numbers = new SortedDictionary<int, string>(); // keys are sorted!

			Console.WriteLine("Add numbers:");
			AddNumbers(numbers);
			Console.WriteLine();

			Console.WriteLine("Add numbers if possible:");
			AddNumbersIfPossible(numbers);
			Console.WriteLine();

			Console.WriteLine("Print numbers:");
			PrintNumbers(numbers);
			Console.WriteLine();

			Console.WriteLine("Print numbers if possible:");
			PrintNumbersIfPossible(numbers);
			Console.WriteLine();

			Console.WriteLine("Print keys:");
			PrintKeys(numbers);
			Console.WriteLine();

			Console.WriteLine("Print values:");
			PrintValues(numbers);
			Console.WriteLine();

			Console.WriteLine("Contains value:");
			ContainsValue(numbers, "one");
		}

		private static void AddNumbers(IDictionary<int, string> numbers)
		{
			try
			{
				numbers.Add(1, "one");
				numbers.Add(4, "four");
				numbers.Add(3, "three");
				numbers.Add(0, "one"); // can have duplicate values!
				numbers[5] = "five"; // this is insert
				numbers[0] = "zero"; // this is update if exists, not insert!
				numbers.Add(1, "One"); // can not have duplicate keys! throws exception!
			}
			catch (ArgumentException e)
			{
				Console.WriteLine(e.Message);
			}
		}

		private static void AddNumbersIfPossible(IDictionary<int, string> numbers)
		{
			if (!numbers.ContainsKey(1))
			{
				numbers.Add(1, "One");
			}
		}
		private static void PrintNumbers(IDictionary<int, string> numbers)
		{
			for (int i = 0; i < numbers.Count; i++)
			{
				try
				{
					Console.WriteLine(numbers[i]);
				}
				catch (KeyNotFoundException e)
				{
					Console.WriteLine(e.Message);
				}
			}
		}
		private static void PrintNumbersIfPossible(IDictionary<int, string> numbers)
		{
			for (int i = 0; i < numbers.Count; i++)
			{
				if (numbers.TryGetValue(i, out string val))
				{
					Console.WriteLine(val);
				}
			}
		}
		private static void PrintKeys(IDictionary<int, string> numbers) => numbers.Keys.ToList().ForEach(Console.WriteLine);

		private static void PrintValues(IDictionary<int, string> numbers) => numbers.Values.ToList().ForEach(Console.WriteLine);

		private static void ContainsValue(IDictionary<int, string> numbers, string value)
		{
			if (numbers.Values.Contains(value))
			{
				Console.WriteLine("Value is present");
			}
		}
	}
}
