﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Country croatia = new Country { Id = 1, Name = "Hrvatska" };
            Country italy = new Country { Id = 2, Name = "Italija" };

            ISet<Country> countries = new SortedSet<Country> { croatia, italy };
            PrintCountries(countries);

            AddCity(croatia, 1, "Zagreb", "10000");
            AddCity(croatia, 2, "Split", "21000");
            AddCity(italy, 3, "Rim", "00100");
            AddCity(italy, 4, "Milano", "20100");

            PrintCitiesFor(croatia);
            PrintCitiesFor(italy);

            Console.WriteLine();

            Console.WriteLine($"{croatia["Split"]}");
        }

        private static void PrintCitiesFor(Country country)
        {
            Console.WriteLine($"{country.Name}:");
            for (int i = 0; i < country.CitiesCount(); i++)
            {
                // ispisujemo gradove preko Indexera u drzavi
                Console.WriteLine(country[i]);
            }
        }

        private static void AddCity(Country country, int id, string name, string postNumber)
        {
            // country[0] = new City();
            country[country.CitiesCount()] = new City
            {
                Id = id,
                Name = name,
                PostNumber = postNumber
            };
        }

        private static void PrintCountries(ISet<Country> countries)
        {
            //foreach (Country country in countries)
            //{
            //    Console.WriteLine(country);
            //}
            countries.ToList().ForEach(country =>
            {
                Console.WriteLine(country);
            });
            //countries.ToList().ForEach(Console.WriteLine);
        }
    }
}
