using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Vjezbe11.PodatkovniSloj
{
    public class Item
    {
        public int Id { get; set; }
        public string Description { get; set; }
        public DateTime Date { get; set; }
        public User User { get; set; }

        private const string DATE_FORMAT = "dd.MM.yyyy.";
        private const char SEPARATOR = '|';

        public override string ToString()
        {
            return $"[{Id}]: {Description}, {Date.ToString(DATE_FORMAT)}, ({User})";
        }

        // Dodali smo Environment.NewLine ('\n') jer AppendAllText
        // ne prelazi u novi red
        public string FormatForFile()
        {
            return $"{Id}{SEPARATOR}{Description}{SEPARATOR}" +
                $"{Date.ToString(DATE_FORMAT)}{SEPARATOR}" +
                $"{User.FormatForFile()}{Environment.NewLine}";
        }

        public static Item ParseFromFile(string line)
        {
            string[] properties = line.Split(SEPARATOR);

            return new Item
            {
                Id = int.Parse(properties[0]),
                Description = properties[1],
                Date = DateTime.ParseExact(properties[2], DATE_FORMAT, null),
                User = User.ParseFromFile(properties[3])
            };
        }

        public override bool Equals(object obj)
        {
            return obj is Item item &&
                   Id == item.Id;
        }

        public override int GetHashCode()
        {
            return 2108858624 + Id.GetHashCode();
        }
    }
}