using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Vjezbe11.PodatkovniSloj
{
    public class User
    {
        public int Id { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }

        private const char SEPARATOR = '#';

        public override string ToString() => $"[{Id}] {FirstName} {LastName}";

        public string FormatForFile()
        {
            return $"{Id}{SEPARATOR}{FirstName}{SEPARATOR}{LastName}";
        }

        public static User ParseFromFile(string line)
        {
            string[] properties = line.Split(SEPARATOR);

            return new User
            {
                Id = int.Parse(properties[0]),
                FirstName = properties[1],
                LastName = properties[2]
            };
        }

        public override bool Equals(object obj)
        {
            return obj is User user &&
                   Id == user.Id;
        }

        public override int GetHashCode()
        {
            return 2108858624 + Id.GetHashCode();
        }
    }
}