﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;

namespace TrelloRepo.Repository
{
    // should not be visible from the outside (other projects) because it is used through IRepository
    // clients should not be aware what repository they use!
    // default access modifier is internal, so we leave it this way
    internal class MemoryRepository : IRepository
    {
        // we cache the entities in memory in ISet<> - there will be no duplicates
        private readonly ISet<User> users = new HashSet<User>();
        private readonly ISet<Item> items = new HashSet<Item>();

        public void AddItem(Item item)
        {
            // since we do not have a method to add User, we can add user when adding item
            users.Add(item.User);
            items.Add(item);
        }
        //we must return copy, not original! - instead we could call from the client and clear it!
        //public ISet<Item> GetItems() => items;
        public ISet<Item> GetItems() => new HashSet<Item>(items);

        // FirstOrDefault() -> returns first item by condition, or default (null)
        public User GetUser(int id) => users.FirstOrDefault(u => u.Id == id);
        //{
        //    foreach (var u in users)
        //    {
        //        if (u.Id == id)
        //        {
        //            return user;
        //        }
        //    }
        //    return null;
        //}

        public ISet<User> GetUsers() => new HashSet<User>(users);
    }
}
