﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            PredicateDemo();
            ConverterDemo();
            ComparisonDemo();
        }

        private class Product
        { 
            public int Id { get; set; }
            public string Title { get; set; }
            public override string ToString() =>$"{Id} - {Title}";
        }

        private static void ComparisonDemo()
        {
            Console.WriteLine("--------COMPARIOSN-----------");
            List<Product> products = new List<Product> { 
                new Product {Id=1, Title="Klizaljnje"},
                new Product {Id=2, Title="Skateboard"},
                new Product {Id=3, Title="Bicikl"},
            };

            Console.WriteLine("ID asc:");
            Comparison<Product> idASC=(a,b)=>a.Id.CompareTo(b.Id);
            products.Sort(idASC);
            products.ForEach(Console.WriteLine);

            Console.WriteLine("Title desc");
            products.Sort((a,b)=>-a.Title.CompareTo(b.Title));
            products.ForEach(Console.WriteLine);
        }

        private static void ConverterDemo()
        {
            Console.WriteLine("-------CONVERTER-------");
            string number = "2";
            Converter<string, int> stringToInt = int.Parse;
            //Func<string, int> stringToInt = int.Parse;
            Console.WriteLine(stringToInt(number));

            Converter<double, double> celsiusToKelvin = c => c + 273.15;
            double temp = -1;
            Console.WriteLine($"{temp}oC={celsiusToKelvin(temp)} K");
        }

        private static void PredicateDemo()
        {
            Console.WriteLine("-----PREDICATE--------");
            Console.WriteLine("Pozitivni brojevi: ");
            Predicate<int> pozitivniBroj = PozitivniBroj;
            //Func<int, bool> pozitivniBroj = PozitivniBroj;

            //funkcionalnost delegata upotrebom lambde
            pozitivniBroj = n => n > 0;

            List<int> list = new List<int>();
            Random random = new Random();
            for (int i = 0; i < 10; i++)
            {
                int broj=random.Next(-10,10);
                Console.WriteLine(pozitivniBroj(broj) ? $"{broj} je pozitivan" : $"{broj} je negativan");
                list.Add(broj);
            }

            Console.WriteLine($"Prvi pozitni broj je: {list.Find(pozitivniBroj)}");
            Console.WriteLine($"Prvi parni broj: {list.Find(n => n % 2 == 0)}");

            Console.WriteLine("STRING:");
            Predicate<string> isNeitherNullOrEmpty = s => s != null && s.Trim().Length != 0;
            string test = "Ana";
            test = " ";
            test = "";
            test = null;
            Console.WriteLine(isNeitherNullOrEmpty(test) ? "Nije prazan niti NULL" : "Prazan string ili null");
        }

        private static bool PozitivniBroj(int n) => n > 0;
    }
}
