﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PodatkovniSloj
{
    public class FileRepository : IRepository
    {
        private const string PATH = "items.txt";

        public void AddItem(Item item)
        {
            string content = $"{item.FormatForFile()}{Environment.NewLine}";
            File.AppendAllText(PATH, content);
        }

        public ISet<Item> GetItems()
        {
            ISet<Item> items = new HashSet<Item>();

            string[] lines = File.ReadAllLines(PATH);

            foreach (string line in lines)
            {
                Item item = Item.ParseFromFile(line);
                items.Add(item);
            }

            return items;
        }
    }
}
