﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak11
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string ime = ReadString("Ime ucenika: ");
            string prezime = ReadString("Prezime ucenika: ");

            int n = ReadInt("Unesite broj ocjena:");
            int[] ocjene = new int[n];

            InsertGades(ocjene);
            PrintScore(ime, prezime, ocjene);

        }

        private static void PrintScore(string ime, string prezime, int[] ocjene)
        {
           double sum = 0;
            //fore+tab+tab
            foreach (var ocjena in ocjene)
            {
                if (ocjena == 1)
                {
                    Console.WriteLine("Ucenik je pao!");
                    return;
                }
                sum += ocjena;
            }
            Console.WriteLine($"Prosjecna ocjena ucenika {ime} {prezime} je {sum/ocjene.Length}");
        }

        private static void InsertGades(int[] ocjene)
        {
            for (int i = 0; i < ocjene.Length; i++)
            { 
                ocjene[i] = ReadIntInRange($"Umetnite {i+1} ocjenu: ",1,5);
            }
        }

        private static int ReadIntInRange(string message, int min, int max)
        {
            int n;
            do
            {
                n = ReadInt(message);
            }while(n<min || n>max);
            return n;
        }

        private static int ReadInt(string message)
        {
            int n;
            do
            { 
                Console.Write(message);
            }while(!int.TryParse(Console.ReadLine(), out n));
            return n;
        }

        private static string ReadString(string message)
        {
            string s;
            do
            {
                Console.Write(message);
                s = Console.ReadLine().Trim();
                //}while(s.Length == 0);
            }while(string.IsNullOrWhiteSpace(s));
            return s;
        }
    }
}
