﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    class Program
    {
        static void Main(string[] args)
        {
            string message = "Croatia is friendly";
            PerformMulticast(message);
            Console.WriteLine();
            PerformMulticastActions(message);
        }

        private static void PerformMulticast(string message)
        {
            Console.WriteLine("Multicast");
            Broadcast emailBroadcast = SendEmail;
            Broadcast messageBroadcast = SendMessage;

            Broadcast multicast = emailBroadcast + messageBroadcast;

            multicast += Ping;

            // sending lambda expression (we cannot unsubscribe, because it is anonymous)    
            multicast += (text) => Console.WriteLine($"sending text: {text}");

            //but we have a very dangerous operator here '='! It overwrites all assigned delegates!!!
            // multicast = (text) => Console.WriteLine($"sending text: {text}");

            multicast -= emailBroadcast;
            multicast -= messageBroadcast;
            multicast -= Ping;

            // this is also dangerous, because maybe there are no delegates!
            //multicast(message);
            multicast?.Invoke(message);
        }

        private static void PerformMulticastActions(string message)
        {
            Console.WriteLine("Multicast Action");
            Action<string> emailBroadcast = SendEmail;
            Action<string> messageBroadcast = SendMessage;

            Action<string> multicast = emailBroadcast + messageBroadcast;

            multicast += Ping;

            // sending lambda expression (we cannot unsubscribe, because it is anonymous)    
            multicast += (text) => Console.WriteLine($"sending text: {text}");

            //but we have a very dangerous operator here '='! It overwrites all assigned delegates!!!
            // multicast = (text) => Console.WriteLine($"sending text: {text}");

            multicast -= emailBroadcast;
            multicast -= messageBroadcast;
            multicast -= Ping;

            // this is also dangerous, because maybe there are no delegates!
            //multicast(message);
            multicast?.Invoke(message);
        }

        private static void SendEmail(string message) => Console.WriteLine($"Sending email: {message}");
        private static void SendMessage(string message) => Console.WriteLine($"Sending message: {message}");
        private static void Ping(string message) => Console.WriteLine($"Pinging: {message}");

        private delegate void Broadcast(string message);
    }
}
