﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak11
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string firstName = ReadString("Enter first name: ");
            string lastName = ReadString("Enter last name: ");

            int n = ReadInt("Enter number of grades: ");
            int[] grades = new int[n];

            InsertGrades(grades);
            PrintResult(firstName, lastName, grades);
        }

        private static void PrintResult(string firstName, string lastName, int[] grades)
        {
            int sum = 0;

            //for (int i = 0; i < grades.Length; i++)
            //{
            //    int grade = grades[i];

            //    if (grade == 1)
            //    {
            //        Console.WriteLine("Student has failed!");
            //        return;
            //    }

            //    sum += grade;
            //}
            foreach (int grade in grades)
            {
                if (grade == 1)
                {
                    Console.WriteLine("Student has failed!");
                    return;
                }

                sum += grade;
            }

            double averageGrade = sum / (double)grades.Length;

            Console.WriteLine($"Student {firstName} {lastName} has avarage grade of {averageGrade}");
        }

        private static void InsertGrades(int[] grades)
        {
            for (int i = 0; i < grades.Length; i++)
            {
                grades[i] = ReadIntInRange($"Enter {i + 1}. grade (1-5): ", 1, 5);
            }
        }

        private static int ReadIntInRange(string message, int min, int max)
        {
            int n;
            do
            {
                n = ReadInt(message);

            } while (n < min || n > max);

            return n;
        }

        private static int ReadInt(string message)
        {
            int n;
            bool succeeded;
            do
            {
                Console.Write(message);
                succeeded = int.TryParse(Console.ReadLine(), out n);

            } while (!succeeded);

            return n;
        }

        private static string ReadString(string message)
        {
            string input;
            do
            {
                Console.Write(message);
                input = Console.ReadLine();

            } while (string.IsNullOrWhiteSpace(input));

            return input;
        }
    }
}
