﻿using CleanCode.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    internal class Kolegij:ISignable
    {
        public string Sifra {  get; set; }
        public string Naziv { get; set; }
        private int ecst;
        public int ECST
        {
            get => ecst;
            set 
            {
                if (value < 20 || value > 30)
                    throw new Exception("ECST bodovi moraju biti izmedu 20 i 30!");
                ecst = value;
            }
        }

        //niti jedan kolegij ne može biti odobren po defaultu, vec samo od strane Dekana
        public bool Odobren { get; private set; }

        public override string ToString() => $"Sifra: {Sifra}, Naziv: {Naziv}, ECST: {ECST.IntInFormat("ects")}, Odobren: {(Odobren ? "DA" : "NE")}";

        public void Sign()=>Odobren = true;
    }
}
