﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        private const string PATH = "demo.txt";

        static void Main(string[] args)
        {
            WriteFile(PATH, "Ovo je OOP.\nDanas je srijeda.");
            try
            {
                string content = ReadFile(PATH);
                Console.WriteLine(content);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void WriteFile(string path, string content)
        {
            StreamWriter writer = null;
            try
            {
                writer = File.CreateText(path);
                writer.WriteLine(content);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            finally
            {
                //if (writer != null)
                //{
                //    writer.Close();
                //}
                writer?.Close();
            }
        }

        // prebacujemo odgovornost handleanja
        // exceptionsa na pozivatelja (Main)
        private static string ReadFile(string path)
        {
            // using rjesava Closeanje (Disposeanje) filea
            using (StreamReader reader = File.OpenText(path))
            {
                return reader.ReadToEnd();
            };
        }
    }
}
