﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task.Solution
{
    // we really do not need any subclasses of Pizza, because pizzas differ only by properties (Ingredients and Price)
    // but the client really needs a way to differentiate between different kinds of pizza, se we do it this way
    internal abstract class Pizza
    {
        // we can have abstract properties - after all, they are methods
        public abstract string Ingredients { get; }
        public abstract double Price { get; set; }
        // all the method implementations are ok - reflection is allowing us to reuse implemented methods in subclasses, and their GetType() method will handle the problem
        public void Prepare() => Console.WriteLine($"{GetType().Name} {nameof(Prepare)}");
        public void Bake() => Console.WriteLine($"{GetType().Name} {nameof(Bake)}");
        public void Serve() => Console.WriteLine($"{GetType().Name} {nameof(Serve)}");
        public void Charge() => Console.WriteLine($"{GetType().Name} {nameof(Charge)}: {Price}");
        public override string ToString() => $"{GetType().Name}: {Ingredients}";
    }
}
