﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            AvoidExceptions();
            ImitateTryParse();
        }

        private static void AvoidExceptions()
        {
            // PROBLEM: two possible exceptions
            string test = null; // NullReferenceException;
            //test = ""; // IndexOutOfRangeException;
            //Console.WriteLine(test.ToLower()[0]);

            // SOLUTIONS:
            // 1. manual - handles all problems!
            //if (test != null && test.Length > 0) // short circuit operator - if left side is false, it does not evaluate right side
            //{
            //    Console.WriteLine(test.ToLower()[0]);
            //}

            // 2. ternary - handles all - we can set default value, if not correct
            //test = test != null && test.Length > 0 ? test : "default";
            //test = !string.IsNullOrEmpty(test) ? test: "default";
            //Console.WriteLine(test.ToLower()[0]);

            // 3. null coalescing operator - It says "If the operand is non-null, give it to me; otherwise, give me a default value."
            // handles only NullReferenceException
            // it is a variant of ELVIS operator ?:
            //test = test ?? "milica";
            //Console.WriteLine(test.ToLower()[0]);

            // 4. null conditional operator - C# calls this ELVIS
            // handles only NullReferenceException, optional chaining operation
            Console.WriteLine(test?.ToLower()[0]);
            Console.WriteLine(test?[0]);
        }

        private static void ImitateTryParse()
        {
            int outValue;
            do
            {
                Console.WriteLine("Number:");
            } while (!TryParse(Console.ReadLine(), out outValue));
            Console.WriteLine(outValue);

            // ref parameter must be initialized prior sending to a method!!!
            int refValue = 0;
            do
            {
                Console.WriteLine("Number:");
            } while (!TryParseRef(Console.ReadLine(), ref refValue));
            Console.WriteLine(refValue);
        }

        private static bool TryParse(string text, out int value)
        {
            try
            {
                value = int.Parse(text);
                return true;
            }
            catch (Exception e) when ( // exception filters
            e is ArgumentNullException ||
            e is FormatException ||
            e is OverflowException)
            {
                // out parameter must be set in the method!!!
                value = 0;
            }
            return false;
        }
        private static bool TryParseRef(string text, ref int value)
        {
            try
            {
                value = int.Parse(text);
                return true;
            }
            // we can ignore exception -> we do not have to put value in ref
            catch { }
            return false;
        }
    }
}
