﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task01
{
    internal class Program
    {
		private const char DELIMITER = ',';

		static void Main(string[] args)
		{
			ISet<int> a;
			do
			{
				Console.WriteLine("Insert elements for A:");
			} while (!TryParseElements(Console.ReadLine(), out a));

			ISet<int> b;
			do
			{
				Console.WriteLine("Insert elements for B:");
			} while (!TryParseElements(Console.ReadLine(), out b));

			IEnumerable<int> union = a.Union(b);
			PrintElements("A union B = ", union);
			PrintElements("A intersect B = ", a.Intersect(b));
			PrintElements("A except B = ", a.Except(b));

			Console.WriteLine(a.IsSubsetOf(b) ? "A is subset of B" : "A is not subset of B");
			Console.WriteLine(a.IsSupersetOf(b) ? "B is subset of A" : "B is not subset of A");
		}

		private static bool TryParseElements(string line, out ISet<int> set)
		{
			//set = new HashSet<int>();
			set = new SortedSet<int>();
			string[] elements = line.Split(DELIMITER);
			foreach (var element in elements)
			{
				try
				{
					if (!set.Add(int.Parse(element)))
					{
						return false;
					}
				}
				catch
				{
					return false;
				}
			}
			return true;
		}
		private static void PrintElements(string message, IEnumerable<int> elements)
		{
			//StringBuilder sb = new StringBuilder($"{message} {{");
			//elements.ToList().ForEach(e => sb.Append(e).Append(DELIMITER));
			// we need to remove last delimiter
			//sb = sb.Remove(sb.Length - 1, 1);
			//sb.Append("}");
			//Console.WriteLine(sb);
			Console.WriteLine($"{message}{{{string.Join(DELIMITER.ToString(), elements)}}}");
		}
	}
}
