﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class Item
    {

        private const string DATE_FORMAT = "dd:MM:yyyy";
        // we use different delimiter from user not to confuse the parser!
        private const char DELIMITER = '|';

        public int Id { get; set; }
        public string Description { get; set; }
        public DateTime Date { get; set; }
        public User User { get; set; }
        public override string ToString() => $"{Description}, {Date.ToString(DATE_FORMAT)}, {User}";
        public override bool Equals(object obj) => obj is Item other && Id == other.Id;
        public override int GetHashCode() => Id.GetHashCode();

        internal string FormatForFileLine() => $"{Id}{DELIMITER}{Description}{DELIMITER}{Date.ToString(DATE_FORMAT)}{DELIMITER}{User.FormatForFileLine()}";

        internal static Item ParseFromFileLine(string line)
        {
            string[] details = line.Split(DELIMITER);
            return new Item
            {
                Id = int.Parse(details[0]),
                Description = details[1],
                Date = DateTime.ParseExact(details[2], DATE_FORMAT, null), // 3r param - IFormatProvider allows for culture-specific options - we do not need it
                User = User.ParseFromFileLine(details[3])
            };
        }
    }
}
