﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task04
{
    internal class Program
    {
        static void Main(string[] args)
        {
            ShowProblem();
            ShowSolution();
        }

        private static void ShowProblem()
        {
            // PROBLEM
            Console.WriteLine(10 / 0.0);
            Console.WriteLine(0 / 0.0);

            // we can check them out:
            if (double.IsInfinity(10 / 0.0))
            {
                Console.WriteLine("Infinity");
            }
            if (double.IsNaN(0 / 0.0))
            {
                Console.WriteLine("Not a number");
            }
            // but we want to disable the possibility of division with 0!
        }

        private static void ShowSolution()
        {
            // 1. introduce a method call
            // 2. throw the exception from the method
            // 3. catch the exception
            // 4. create documentation
            try
            {
                double num = 10;
                double den = 0;
                double quotient = Divide(num, den);
                Console.WriteLine(quotient);
            }
            catch (DivideByDoubleZeroException e)
            {
                Console.WriteLine(e.Message);
            }
        }

        /// <summary>
        /// Divides numbers if denominator is not zero
        /// </summary>
        /// <param name="num"></param>
        /// <param name="den"></param>
        /// <returns></returns>
        /// <exception cref="DivideByDoubleZeroException"></exception>
        private static double Divide(double num, double den)
        {
            if (den == 0)
            {
                //throw new DivideByDoubleZeroException(); // DivideByZeroException
                throw new DivideByDoubleZeroException($"{num} / {den} cannot be divided!");
            };
            return num / den;
        }
    }
}
