﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using TrelloRepo.Model;
using TrelloRepo.Repository;

namespace DesktopClient
{
    public partial class MainForm : Form
    {
        private static readonly IRepository repository = RepositoryFactory.GetRepository();
        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            FillUsers();
            FillItems();
        }
        // we cannot use ISet<> as DataSource, but List<>
        private void FillUsers() => CbUsers.DataSource = repository.GetUsers().ToList();

        private void FillItems() => LbItems.DataSource = repository.GetItems().ToList();

        private void BtnAdd_Click(object sender, EventArgs e)
        {
            if (FormValid())
            {
                repository.AddItem(new Item
                {
                    Date = DtpDate.Value,
                    Description = TbDescription.Text.Trim(),
                    Id = int.Parse(TbId.Text.Trim()),
                    User = CbUsers.SelectedItem as User
                });
                FillItems();
                ClearForm();
            }
        }

        private bool FormValid()
        {
            if (!int.TryParse(TbId.Text.Trim(), out int id))
            {
                MessageBox.Show("Please insert valid id");
                TbId.Focus();
                return false;
            }
            if (string.IsNullOrEmpty(TbDescription.Text))
            {
                MessageBox.Show("Please insert valid description");
                TbDescription.Focus();
                return false;
            }
            return true;
        }
        private void ClearForm()
        {
            TbId.Clear();
            TbDescription.Clear();
            DtpDate.Value = DateTime.Now;
        }
    }
}
