﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    class Program
    {
        static void Main(string[] args)
        {
            PredicatesDemo();
            ConvertersDemo();
            ComparisonDemo();
        }

        private static void PredicatesDemo()
        {
            Console.WriteLine("--------------Predicate-----------------");
            Console.WriteLine("Positive numbers:");
            Predicate<int> positiveNumber = PositiveNumber;
            // Predicate<int> can be expressed as Func<int, bool>:
            //Func<int, bool> positiveNumber = PositiveNumber;
            
            // we do not need a method at all, we just need the functionality!
            positiveNumber = n => n > 0;

            List<int> list = new List<int>();
            Random rnd = new Random();
            for (int i = 0; i < 10; i++)
            {
                int number = rnd.Next(-10, 10);
                Console.WriteLine(positiveNumber(number) ? $"{number} is positive" : $"{number} is negative");
                list.Add(number);
            }

            Console.WriteLine($"Positive: {list.Find(positiveNumber)}");
            Console.WriteLine($"Even: {list.Find(n => n % 2 != 0)}");

            Console.WriteLine("Strings:");
            Predicate<string> isNeitherNullNorEmpty = s => s != null && s.Trim().Length != 0;

            string test = "Milica";
            //test = " ";
            //test = "";
            //test = null;
            Console.WriteLine(isNeitherNullNorEmpty(test) ? "Neither null nor empty" : "Null or empty");
        }

        private static bool PositiveNumber(int n) => n > 0;

        private static void ConvertersDemo()
        {
            Console.WriteLine("--------------Converter-----------------");
            string number = "2";
            Converter<string, int> stringToInt = int.Parse;
            // Converter<string, int> can be expressed as Func<string, int>!
            //Func<string, int> stringToInt = int.Parse;
            Console.WriteLine(stringToInt(number));

            Converter<double, double> celsiusToKelvin = c => c + 273.15;

            double neeves = 10.15;
            Console.WriteLine($"{neeves} oC = {celsiusToKelvin(neeves)} K");
        }

        private static void ComparisonDemo()
        {
            Console.WriteLine("--------------Comparison-----------------");
            List<Product> products = new List<Product>
            {
                new Product {Id = 1, Title = "Rollerblades"},
                new Product {Id = 3, Title = "Skateboard"},
                new Product {Id = 2, Title = "Bicycle"},
            };
            Console.WriteLine("ID ASC:");
            Comparison<Product> idAsc = (a, b) => a.Id.CompareTo(b.Id);
            products.Sort(idAsc);
            products.ForEach(Console.WriteLine);

            Console.WriteLine("TITLE DESC:");
            products.Sort((a, b) => -a.Title.CompareTo(b.Title));
            products.ForEach(Console.WriteLine);

        }
        private class Product
        {
            public int Id { get; set; }
            public string Title { get; set; }
            public override string ToString() => $"{Id} - {Title}";
        }
    }
}
