﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task.Problem
{
    internal class Margherita
    {
        // automatic property initializer -> auto-implemented properties - default values
        // we can hide setter, 'cause Margherita is not going to change
        public string Ingredients { get; } = "Tomato, Cheese";
        // we allow the price to change, but we have a default value
        public double Price { get; set; } = 8.99;
        // we can see that we use "Margherita" as string, but in the same time, it is a class name
        //public void Prepare() => Console.WriteLine("Preparing Margherita");
        // using Type as a introduction to reflections
        // every object has GetType() method that returns its Type
        // C# objects have a pointer to their type, so when you call GetType() it checks that pointer and returns the real type of an object
        // examples:
        // GetType() - we get Assembly name, namespace, class name
        // GetType().Assembly - we get the assembly 
        // GetType().Namespace - we get the namespace 
        // GetType().Name - we get the class name
        // GetType().FullName - we get the namespace + class name
        // nameof(MethodName) - gives us the name of the method
        public void Prepare() => Console.WriteLine($"{GetType().Name} {nameof(Prepare)}");
        public void Bake() => Console.WriteLine($"{GetType().Name} {nameof(Bake)}");
        public void Serve() => Console.WriteLine($"{GetType().Name} {nameof(Serve)}");
        public void Charge() => Console.WriteLine($"{GetType().Name} {nameof(Charge)}: {Price}");
        // seems that default ToString() from Object is calling GetType() and prints the type!!
        public override string ToString() => $"{GetType().Name}: {Ingredients}";
    }
}
