﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task.Solution
{
    // we do not have any state in the PizzaFactory objects - we can make it static, because this class is only about behavior, and that behavior is not specific to any of the objects - conclusion: we do not need an object of this type
    internal static class PizzaFactory
    {
        internal static Pizza GetPizza(string name)
        {
            Pizza pizza;
            switch (name)
            {
                case "Margherita":
                    pizza = new Margherita();
                    break;
                case "Capricciosa":
                    pizza = new Capricciosa();
                    break;
                case "Vegetariana":
                    pizza = new Vegetariana();
                    break;
                default:
                    // it's better to throw an exception than to serve what wasn't ordered!
                    throw new Exception("No such pizza");
            }
            pizza.Prepare();
            pizza.Bake();
            pizza.Serve();
            pizza.Charge();
            return pizza;
        }
        internal static Pizza GetPizzaByReflection(string name)
        {
            Pizza pizza = GetPizzaByClassName(name);

            pizza.Prepare();
            pizza.Bake();
            pizza.Serve();
            pizza.Charge();
            return pizza;
        }
        private static Pizza GetPizzaByClassName(string name)
        {
            // we recognize this - this is Factory pattern for type!!!
            Type type = Type.GetType(name);
            return Activator.CreateInstance(type) as Pizza;
        }
    }
}
