﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task02.Model
{
    internal class Country : IComparable<Country>
    {
        private readonly IList<City> cities = new List<City>();
        public int Id { get; set; }
        public string Name { get; set; }
        public override string ToString() => $"{Id} - {Name}";
        public int CompareTo(Country other) => -Name.CompareTo(other.Name);
        internal int CitiesCount() => cities.Count();
        public City this[int index]
        {
            get => cities[index];
            set => cities.Insert(index, value);
        }
        public City this[string name]
        {
            get => cities.FirstOrDefault(c => c.Name == name);
        }
    }
}
