﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Task02.Model;

namespace Task02
{
    internal class Program
    {
		private static readonly ISet<Country> countries = new SortedSet<Country>();
		static void Main(string[] args)
		{
			AddCountry(1, "Hrvatska");
			AddCountry(2, "Italia");
			AddCountry(3, "England");
			AddCountry(5, "Hrvatska"); // this one should not insert if IComparable uses Name, and SortedSet uses IComparable for equality check!
			Console.WriteLine();
			ListCountries();
			AddCity(countries.FirstOrDefault(c => c.Name == "Hrvatska"), 1, "Zagreb", 10000);
			AddCity(countries.FirstOrDefault(c => c.Name == "Hrvatska"), 2, "Split", 21000);
			AddCity(countries.FirstOrDefault(c => c.Name == "Italia"), 3, "Livorno", 12000);
			AddCity(countries.FirstOrDefault(c => c.Name == "Italia"), 4, "Roma", 30000);
			AddCity(countries.FirstOrDefault(c => c.Name == "England"), 5, "Liverpool", 80000);
			AddCity(countries.FirstOrDefault(c => c.Name == "England"), 6, "London", 60000);

			Console.WriteLine("\nHrvatska:");
			ListCitiesForCountry(countries.FirstOrDefault(c => c.Name == "Hrvatska"));
			Console.WriteLine("\nItalia:");
			ListCitiesForCountry(countries.FirstOrDefault(c => c.Name == "Italia"));
			Console.WriteLine("\nEngland:");
			ListCitiesForCountry(countries.FirstOrDefault(c => c.Name == "England"));

			Console.WriteLine("City by name");
			PrintCityByName(countries.FirstOrDefault(c => c.Name == "England"), "London");
		}

		private static void AddCountry(int id, string name)
		{
			if (countries.Add(new Country { Id = id, Name = name }))
			{
				Console.WriteLine("Country inserted!");
			}
			else
			{
				Console.WriteLine("Duplicate country!");
			}
		}

		private static void ListCountries() => countries.ToList().ForEach(Console.WriteLine);

		private static void AddCity(Country country, int id, string name, int postNumber) => country[country.CitiesCount()] = new City { Id = id, Name = name, PostNumber = postNumber };

		private static void ListCitiesForCountry(Country country)
		{
			for (int i = 0; i < country.CitiesCount(); i++)
			{
				Console.WriteLine(country[i]);
			}
		}
		private static void PrintCityByName(Country country, string name) => Console.WriteLine(country[name]);

	}
}
