﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PripremaIspit
{
    public class Prodaja : IComparable<Prodaja>
    {
        public Prodaja(DateTime datum, Kupac kupac, int iznos, IPopust popust, Automobil automobil)
        {
            Datum = datum;
            Kupac = kupac;
            Iznos = iznos;
            Popust = popust;
            Automobil = automobil;
        }

        //        U knjizi prodaje potrebno je evidentirati tko je kupio(Kupac), datum i iznos koji je
        //plaćen(kupac je mogao dobiti neki popust ili slično, pa se cijena može razlikovati od cijene po
        //kojoj se automobil prodaje).

        public DateTime Datum { get; set; }
        public Kupac Kupac { get; set; }
        public int Iznos { get; set; }

        public IPopust Popust { get; set; }

        public Automobil Automobil { get; set; }

        public int CompareTo(Prodaja other)
        {
            return (-1) * Popust.IzracunajPopust(Iznos).CompareTo(other.Popust.IzracunajPopust(other.Iznos));
        }

        public override string ToString()
        {
            return $"Naziv Kupca: {Kupac.Ime}, Cijena: {Popust.IzracunajPopust(Iznos)}kn, Automobil: {Automobil.Marka}";
        }
    }
}
